print("Made by Erik Oellers\n\nStarting up...")
print("Getting Info...")
import time
print("Time")
import tkinter as tk
print("Visuals")
import screeninfo
print("Got Screeninfo")
import threading
print("Threads")
import keyboard
print("keyboard infos")
import random
print("randomness")
import sys
print("system")
import ctypes
print("Console Properties")


#pip install screeninfo
#pip install keyboard


try:
    print("\nLoading shared class")
    class shared:
        def __init__(self):
            self.bot_active = True
            self.size = 0.75
            self.r_pos = 0.6
            self.l_pos = 0.6
            self.ball_pos_x = 0.5
            self.ball_pos_y = 0.6
            self.dir = "r"
            self.ball = None
            self.hitbox_range = 0.135
            self.ball_move_multiplier_y = 1
            self.ball_move_multiplier_x = 1
            self.ball_addition = 0
            self.score_1 = 0
            self.score_2 = 0
            self.end = False


    s = shared()

    print("loading mechanics...")
    def size():
        text_input = str(s.size)
        text_output = text_input.replace(".0", ".00").replace(".5", ".50")
        return text_output
    def toggle_bot():
        if s.bot_active:
            bot_button.configure(background="#000000", foreground="#ffffff")
            s.bot_active = False
        else:
            bot_button.configure(background="#ffffff", foreground="#000000")
            s.bot_active = True

    def change_size():
        global size
        if s.size < 1.5:
            s.size += 0.25
        else:
            s.size = 0.25
        s.hitbox_range = s.size * 0.13
        button_size.configure(text=size())
        pf_r.configure(height=(round(s.size * 10)), width=(round(s.size * 3)))
        pf_l.configure(height=(round(s.size * 10)), width=(round(s.size * 3)))
        s.ball.configure(height=(round(s.size * 10)), width=(round(s.size * 10)))
        print(f"height={(round(s.size * 10))}, width={(round(s.size * 3))}")


    print("\n\nCreating Visuals...")
    width = screeninfo.get_monitors()[0].width
    height = screeninfo.get_monitors()[0].height

    frame_width = round(width / 2.3)
    frame_height = round(height / 2)

    frame = tk.Tk()
    frame.geometry(f"{frame_width}x{frame_height}")
    frame.configure(background="#000000")
    frame.title("Pong - Erik Oellers")
    frame.update()

    print("Creating Props...")
    title = tk.Label(frame, text="PONG", background="#000000", foreground="#ffffff", font=("Helvetica", 36))

    bot_button = tk.Button(
        frame, text="BOT", background="#ffffff", foreground="#000000", font=("Helvetica", 25),
        borderwidth=0, relief="solid", command=toggle_bot
        )
    button_size = tk.Button(
        frame, text=size(), background="#ffffff", foreground="#000000", font=("Helvetica", 25),
        borderwidth=0, relief="solid", command=change_size
    )

    pf_r = tk.Label(text="", background="#ffffff", height=(round(s.size * 10)), width=(round(s.size * 3)))
    pf_l = tk.Label(text="", background="#ffffff", height=(round(s.size * 10)), width=(round(s.size * 3)))

    menu_line = tk.Label(text="___" * 999, background="#000000", foreground="#ffffff", height=1, width=1000)

    s.ball = tk.Frame(height=(round(s.size * 10)), width=(round(s.size * 10)))

    scoreboard_1 = tk.Label(text=s.score_1, background="#000000",foreground="#ffffff", font=("Helvetica", 50))
    scoreboard_2 = tk.Label(text=s.score_2, background="#000000",foreground="#ffffff", font=("Helvetica", 50))


    print("Placing Props...")
    title.place(rely=0.1, relx=0.5, anchor="center")
    bot_button.place(rely=0.1, relx=0.1, anchor="center")
    button_size.place(rely=0.1, relx=0.9, anchor="center")
    menu_line.place(rely=0.19, relx=0.5, anchor="center")
    pf_r.place(rely=s.r_pos, relx=0.9, anchor="center")
    pf_l.place(rely=s.r_pos, relx=0.1, anchor="center")
    s.ball.place(rely=s.ball_pos_y, relx=s.ball_pos_x, anchor="center")
    scoreboard_1.place(rely=0.1, relx=0.3, anchor="center")
    scoreboard_2.place(rely=0.1, relx=0.7, anchor="center")
    frame.update()

    print("loading movement...")
    def move_right(direction):
        if direction == "up":
            if s.r_pos > 0.35:
                s.r_pos -= 0.01
        elif direction == "down":
            if s.r_pos < 0.85:
                s.r_pos += 0.01

    def move_left(direction):
        if direction == "up":
            if s.l_pos > 0.35:
                s.l_pos -= 0.01
        elif direction == "down":
            if s.l_pos < 0.85:
                s.l_pos += 0.01

    print("loading bot activities...")
    def bot_activity():
        print("\nBot Activity Started!")
        time.sleep(1)
        while True:
            if s.end:
                break
            if s.bot_active:
                if s.ball_pos_x < 0.4:
                    if s.ball_pos_y > s.l_pos + 0.05:
                        move_left("down")
                    elif s.ball_pos_y < s.l_pos + 0.05:
                        move_left("up")
            time.sleep(0.0333333)


    print("loading ball logic...")
    def ball_activity():
        print("\nBall Logic Started!")
        time.sleep(1)
        for i in range(5):
            s.score_1 = 5 - i
            s.score_2 = 5 - i
            time.sleep(1)
        s.score_1 = 0
        s.score_2 = 0
        # r, u, l, d
        # ru, ul, ld, dr
        last_dir = s.dir
        while True:
            if s.end:
                break
            time.sleep(0.033333334)
            print(f"{s.ball_pos_y} --- {s.r_pos - s.hitbox_range} , {s.r_pos + s.hitbox_range} ::: {s.dir} !!! "
                  f" {s.ball_move_multiplier_x} -- {s.ball_move_multiplier_y} ??? {s.ball_addition}")
            if s.ball_pos_x > 0.88 and s.ball_pos_y > s.r_pos - s.hitbox_range and s.ball_pos_y < s.r_pos:
                s.dir = "ul"

            elif s.ball_pos_x > 0.88 and s.ball_pos_y < s.r_pos + s.hitbox_range and s.ball_pos_y > s.r_pos:
                s.dir = "ld"
            elif s.ball_pos_x > 0.88 and s.ball_pos_y == s.r_pos:
                s.dir = "l"

            elif s.ball_pos_x < 0.12 and s.ball_pos_y > s.l_pos - s.hitbox_range and s.ball_pos_y < s.l_pos:
                s.dir = "ru"

            elif s.ball_pos_x < 0.12 and s.ball_pos_y < s.l_pos + s.hitbox_range and s.ball_pos_y > s.l_pos:
                s.dir = "dr"
            elif s.ball_pos_x < 0.12 and s.ball_pos_y == s.l_pos:
                s.dir = "r"

            elif s.ball_pos_y < 0.22:
                if s.dir == "ru":
                    s.dir = "dr"

                elif s.dir == "ul":
                    s.dir = "ld"

            elif s.ball_pos_y > 0.99:
                if s.dir == "dr":
                    s.dir = "ru"

                elif s.dir == "ld":
                    s.dir = "ul"

            if s.ball_pos_x > 0.95:
                time.sleep(0.25)
                s.score_1 += 1
                time.sleep(0.25)
                s.ball_pos_x = 0.5
                s.ball_pos_y = 0.6
                s.r_pos = 0.6
                s.l_pos = 0.6
                s.ball_addition = 0
                s.dir = random.choice(["l", "r"])
                time.sleep(1)
            elif s.ball_pos_x < 0.05:
                time.sleep(0.25)
                s.score_2 += 1
                time.sleep(0.25)
                s.ball_pos_x = 0.5
                s.ball_pos_y = 0.6
                s.r_pos = 0.6
                s.l_pos = 0.6
                s.ball_addition = 0
                s.dir = random.choice(["l", "r"])
                time.sleep(1)


            if s.dir != last_dir:
                s.ball_move_multiplier_x = random.uniform(1.00, 1.25)
                s.ball_move_multiplier_y = random.uniform(1.00, 1.25)
                s.ball_addition += 0.0002
                last_dir = s.dir

            if s.dir == "r":
                s.ball_pos_x += (0.01 * s.ball_move_multiplier_x) + s.ball_addition
            elif s.dir == "l":
                s.ball_pos_x -= (0.01 * s.ball_move_multiplier_x) + s.ball_addition
            elif s.dir == "u":
                s.ball_pos_y -= (0.01 * s.ball_move_multiplier_y) + s.ball_addition
            elif s.dir == "d":
                s.ball_pos_y += (0.01 * s.ball_move_multiplier_y) + s.ball_addition

            elif s.dir == "ru":
                s.ball_pos_x += (0.01 * s.ball_move_multiplier_x) + s.ball_addition
                s.ball_pos_y -= (0.01 * s.ball_move_multiplier_y) + s.ball_addition
            elif s.dir == "ul":
                s.ball_pos_x -= (0.01 * s.ball_move_multiplier_x) + s.ball_addition
                s.ball_pos_y -= (0.01 * s.ball_move_multiplier_y) + s.ball_addition
            elif s.dir == "ld":
                s.ball_pos_y += (0.01 * s.ball_move_multiplier_y) + s.ball_addition
                s.ball_pos_x -= (0.01 * s.ball_move_multiplier_x) + s.ball_addition
            elif s.dir == "dr":
                s.ball_pos_y += (0.01 * s.ball_move_multiplier_y) + s.ball_addition
                s.ball_pos_x += (0.01 * s.ball_move_multiplier_x) + s.ball_addition
            else:
                print("dont know direction: " + s.dir)


    print("Starting Threads...")
    bota_thread = threading.Thread(target=bot_activity)
    bota_thread.start()
    balla_thread = threading.Thread(target=ball_activity)
    balla_thread.start()




    print("\n\nEverything Started! Removing Console...")
    time.sleep(1)
    if sys.platform == "win32":
        ctypes.windll.user32.ShowWindow(ctypes.windll.kernel32.GetConsoleWindow(), 0)
    try:
        while True:
            if s.end:
                break
            if keyboard.is_pressed("up"):
                move_right("up")
            if keyboard.is_pressed("down"):
                move_right("down")
            if not s.bot_active:
                if keyboard.is_pressed("w"):
                    move_left("up")
                if keyboard.is_pressed("s"):
                    move_left("down")
            s.ball.place_configure(relx=s.ball_pos_x, rely=s.ball_pos_y)
            scoreboard_1.configure(text=s.score_1)
            scoreboard_2.configure(text=s.score_2)
            pf_r.place_configure(rely=s.r_pos)
            pf_l.place_configure(rely=s.l_pos)

            frame.update()
            time.sleep(0.033333333333333336)
    except:
        print("ending threads...")
        s.end = True
        bota_thread.join()
        balla_thread.join()
        print("threads ended")

        raise SystemExit

except Exception as e:
    print(e)
    time.sleep(120)

