print("PACMAN by Erik Oellers")
print("loading packages")
try:
    import random
    import tkinter as tk
    import screeninfo
    import time
    from PIL import Image, ImageTk
    import numpy as np
    import img_bits
    import threading
    import keyboard
    import coordinates
    import sys
    import ctypes
    print("Loaded!")

    """
    pip install screeninfo
    pip install pillow
    pip install numpy
    pip install keyboard
     """

    print("Creating Shared Variables/entity States...")
    class shared:
        def __init__(self):
            self.blocks = []
            self.koords = coordinates.get_blocks()
            self.ghost_speed = 0.025
            self.collected_coin_blocks = []
            self.all_coins_count = 0
            self.all_collected_count = 0
            self.prep_g1 = False
            self.prep_g2 = False
            self.prep_g3 = False
            self.prep_g4 = False
            self.caught = False
            # ghost 1
            self.ghost_1 = None
            self.g_1_x = 0.05
            self.g_1_y = 0.05
            self.g_1_dir = "u"
            self.change_dir_g1 = False
            self.last_three_turns_g1 = [[None, None], [None, None]]
            # ghost 2
            self.ghost_2 = None
            self.g_2_x = 0.05
            self.g_2_y = 0.05
            self.g_2_dir = "r"
            self.change_dir_g2 = False
            self.last_three_turns_g2 = [[None, None], [None, None]]
            # ghost 3
            self.ghost_3 = None
            self.g_3_x = 0.05
            self.g_3_y = 0.05
            self.g_3_dir = "l"
            self.change_dir_g3 = False
            self.last_three_turns_g3 = [[None, None], [None, None]]
            # ghost 4
            self.ghost_4 = None
            self.g_4_x = 0.05
            self.g_4_y = 0.05
            self.g_4_dir = "d"
            self.change_dir_g4 = False
            self.last_three_turns_g4 = [[None, None], [None, None]]

            #pacman
            self.pacman = None
            self.old_dir_pm = "None"
            self.p_dir = "d"
            self.powerup_active = False
            self.p_x = 0.05
            self.p_y = 0.05
    print("Done")
    def reset():
        time.sleep(2.5)

        s.all_collected_count = 0
        s.prep_g1 = False
        s.prep_g2 = False
        s.prep_g3 = False
        s.prep_g4 = False
        s.caught = False
        # ghost 1
        s.g_1_x = 0.05
        s.g_1_y = 0.05
        s.g_1_dir = "u"
        s.change_dir_g1 = False
        s.last_three_turns_g1 = [[None, None], [None, None]]
        # ghost 2
        s.g_2_x = 0.05
        s.g_2_y = 0.05
        s.g_2_dir = "r"
        s.change_dir_g2 = False
        s.last_three_turns_g2 = [[None, None], [None, None]]
        # ghost 3
        s.g_3_x = 0.05
        s.g_3_y = 0.05
        s.g_3_dir = "l"
        s.change_dir_g3 = False
        s.last_three_turns_g3 = [[None, None], [None, None]]
        # ghost 4
        s.g_4_x = 0.05
        s.g_4_y = 0.05
        s.g_4_dir = "d"
        s.change_dir_g4 = False
        s.last_three_turns_g4 = [[None, None], [None, None]]

        # pacman
        s.old_dir_pm = "None"
        s.p_dir = "d"
        s.powerup_active = False
        s.p_x = 0.05
        s.p_y = 0.05

        for coinblock in coins:
            try:
                coinblock[0].place_configure(relx=coinblock[1], rely=coinblock[2])
            except:
                pass
        s.collected_coin_blocks = []
        frame.update()

    s = shared()

    print("Creating Frame...")

    width = screeninfo.get_monitors()[0].width
    height = screeninfo.get_monitors()[0].height

    frame_width = round(width / 2.3)
    frame_height = round(height / 2)

    frame = tk.Tk()
    frame.geometry(f"{frame_height}x{frame_height}")
    frame.configure(background="#000000")
    frame.title("PacMan - Erik Oellers")
    frame.resizable(False, False)

    print("Done")
    print("Closing Console...")
    if sys.platform == "win32":
            ctypes.windll.user32.ShowWindow(ctypes.windll.kernel32.GetConsoleWindow(), 0)

    block_size_divider = 20.3
    block_height, block_width = round(frame_height / block_size_divider), round(frame_height / block_size_divider)

    koords_logo = coordinates.get_logo()

    frame.update()
    for i in koords_logo:
        try:
            print(i)
            if i[2] == 1:
                bl = tk.Frame(frame, height=block_height, width=block_width, background="#1919A6")
                bl.place(relx=i[0], rely=i[1])
                s.blocks.append(bl)
            elif i[2] == 2:
                bl = tk.Frame(frame, height=block_height, width=block_width, background="#2121DE")
                bl.place(relx=i[0], rely=i[1])
                s.blocks.append(bl)
            else:
                print(f'"{i}" is not usable!')
        except:
            print(f'"{i}" is not usable!')
        time.sleep(0.03)
        frame.update()

    print(len(s.blocks))

    dot = tk.Frame(frame, height=block_height, width=block_width, background="#2121DE")
    for i in range(5):
        dot.place(relx=0.9, rely=0.85)

        frame.update()
        time.sleep(0.5)
        dot.place_forget()
        frame.update()
        time.sleep(0.5)
    for block in s.blocks:
        print(block)
        time.sleep(0.01)
        block.place_configure(relx=1)
        frame.update()

    time.sleep(2.5)

    print(len(s.blocks))
    s.blocks = []

    #[x, y, kind]




    for i in s.koords:
        frame.update()
        time.sleep(0.01)
        try:
            print(i)
            if i[2] == 1:
                s.blocks.append(tk.Frame(frame, height=block_height, width=block_width, background="#1919A6")
                            .place(relx=i[0], rely=i[1]))
            elif i[2] == 2:
                s.blocks.append(tk.Frame(frame, height=block_height, width=block_width, background="#2121DE")
                                .place(relx=i[0], rely=i[1]))
            elif i[2] == 3:
                s.blocks.append(tk.Frame(frame, height=block_height, width=block_width, background="#FFFFFF")
                              .place(relx=i[0], rely=i[1]))
            else:
                print(f'"{i}" is not usable!')
        except:
            print(f'"{i}" is not usable!')


    coins = []
    coinless_koords = coordinates.get_coinless()

    for i in range(20):
        for u in range(20):
            i_u_divider = 20
            print([i / i_u_divider, u / i_u_divider, 1])
            if not [i / i_u_divider, u / i_u_divider, 1] in s.koords and not [i / i_u_divider, u / i_u_divider, 2] in s.koords:
                if not [i / i_u_divider, u / i_u_divider] in coinless_koords:
                    time.sleep(0.01)
                    frame.update()
                    place_x = round((i / i_u_divider) + 0.015, 3)
                    place_y = round((u / i_u_divider) + 0.015, 3)
                    coin = tk.Frame(frame, height=round(block_height / 3), width=round(block_width / 3), background="#FFFF00")
                    coin.place(relx=place_x, rely=place_y)
                    coins.append([coin, place_x, place_y])

    s.all_coins_count = len(coins)

    print(len(coins))

    def move_pacman(add_x, add_y):
        s.p_x += (add_x) / 10
        s.p_y += (add_y) / 10
    def move_ghost_1(add_x, add_y):
        s.g_1_x += (add_x * 2.5) / 10
        s.g_1_y += (add_y * 2.5) / 10
    def move_ghost_2(add_x, add_y):
        s.g_2_x += (add_x * 2.5) / 10
        s.g_2_y += (add_y * 2.5) / 10

    def move_ghost_3(add_x, add_y):
        s.g_3_x += (add_x * 2.5) / 10
        s.g_3_y += (add_y * 2.5) / 10

    def move_ghost_4(add_x, add_y):
        s.g_4_x += (add_x * 2.5) / 10
        s.g_4_y += (add_y * 2.5) / 10

    frame.update()
    #time.sleep(5)

    #ghost_1 red
    s.ghost_1 = tk.Label(frame)
    #ghost_2 orange
    s.ghost_2 = tk.Label(frame)
    #ghost_3 pink
    s.ghost_3= tk.Label(frame)
    #ghost_4 cyan
    s.ghost_4 = tk.Label(frame)




    turn_points = coordinates.get_turn_points()

    def ghost_1_logic():
        if not s.prep_g1:
            print("Prepping g1")
            s.g_1_x = 0.5
            s.g_1_y = 0.5
            s.last_three_turns_g1 = [[None, None], [None, None]]
            s.prep_g1 = True
        if True:
            #
            #print(f"[{round(s.g_1_x, 2)},  {round(s.g_1_y + 0.05, 2)}, 1]")
            if s.g_1_dir == "r":
                if [round(s.g_1_x + 0.05, 2), round(s.g_1_y, 2), 1] in s.koords:
                    #print("wall")
                    s.change_dir_g1 = True
                else:
                    move_ghost_1(s.ghost_speed, 0)


            elif s.g_1_dir == "l":
                if [round(s.g_1_x - 0.05, 2), round(s.g_1_y, 2), 1] in s.koords:
                    #print("wall")
                    s.change_dir_g1 = True
                else:
                    move_ghost_1(s.ghost_speed * -1, 0)


            elif s.g_1_dir == "d":
                if [round(s.g_1_x, 2), round(s.g_1_y + 0.05, 2), 1] in s.koords:
                    #print("wall")
                    s.change_dir_g1 = True
                else:
                    move_ghost_1(0, s.ghost_speed)


            elif s.g_1_dir == "u":
                if [round(s.g_1_x, 2), round(s.g_1_y - 0.05, 2), 1] in s.koords:
                    #print("wall")
                    s.change_dir_g1 = True
                else:
                    move_ghost_1(0, s.ghost_speed * -1)

            for koord in turn_points:
                if s.g_1_x > koord[0] + 0 and s.g_1_x < koord[0] + 0.05:
                    if s.g_1_y > koord[1] + 0 and s.g_1_y < koord[1] + 0.01:
                        if len(str(round(round(s.g_1_x, 2), 2))) == 3 or str(round(s.g_1_x, 2)).endswith("5"):
                            if len(str(round(round(s.g_1_y, 2), 2))) == 3 or str(round(s.g_1_y, 2)).endswith("5"):
                                if not [round(s.g_1_y, 2), round(s.g_1_x, 2)] in s.last_three_turns_g1:
                                    if random.randint(1, 5) > 1:
                                        s.last_three_turns_g1.remove(s.last_three_turns_g1[0])
                                        s.last_three_turns_g1.append([round(s.g_1_y, 2), round(s.g_1_x, 2)])
                                        s.change_dir_g1 = True



            if s.change_dir_g1:
                change_list = [1,2,3,4, 1,1]
                random.shuffle(change_list)
                for v in range(0, 3):
                    #print(v)
                    #print(change_list)
                    if change_list[v] == 1: #ChangeToRight
                        #print("TRYING RIGHT")
                        if not [round(s.g_1_x + 0.05, 2), round(s.g_1_y, 2), 1] in s.koords:
                            s.g_1_dir = "r"
                            break
    #

                    elif change_list[v] == 2: #ChangeToLeft
                        #print("TRYING LEFT")
                        if not [round(s.g_1_x - 0.05, 2), round(s.g_1_y, 2), 1] in s.koords:
                            s.g_1_dir = "l"
                            break


                    elif change_list[v] == 4: #ChangeToUp
                        #print("TRYING UP")
                        if not [round(s.g_1_x, 2), round(s.g_1_y - 0.05, 2), 1] in s.koords:
                            s.g_1_dir = "u"
                            break


                    elif change_list[v] == 3: #ChangeToDown
                        print("TRYING DOWN")
                        if not [round(s.g_1_x, 2), round(s.g_1_y + 0.05, 2), 1] in s.koords:
                            s.g_1_dir = "d"
                            break
                s.change_dir_g1 = False

            if s.g_1_x > 1:
                s.g_1_x = -0.05
            if s.g_1_x < -0.05:
                s.g_1_x = 1

            if s.powerup_active:
                if s.g_1_x > s.p_x + 0.0 and s.g_1_x < s.p_x + 0.05:
                    if s.g_1_y > s.p_y + 0 and s.g_1_y < s.p_y + 0.01:
                        for p in range(3):
                            s.g_1_dir = "u"
                            time.sleep(0.1)
                            s.g_1_dir = "r"
                            time.sleep(0.1)
                            s.g_1_dir = "d"
                            time.sleep(0.1)
                            s.g_1_dir = "l"
                            time.sleep(0.1)
                        s.g_1_y = 0.5
                        s.g_1_x = 0.5
                        while s.powerup_active:
                            s.g_1_dir = "u"
                            time.sleep(0.1)
                            s.g_1_dir = "r"
                            time.sleep(0.1)
                            s.g_1_dir = "d"
                            time.sleep(0.1)
                            s.g_1_dir = "l"
                            time.sleep(0.1)



    def ghost_2_logic():
        if not s.prep_g2:
            print("Prepping g2")
            s.g_2_x = 0.5
            s.g_2_y = 0.5
            s.last_three_turns_g2 = [
                [None, None],
                [None, None],
            ]
            s.prep_g2 = True
        if s.prep_g2:
            #
            #print(f"[{round(s.g_2_x, 2)},  {round(s.g_2_y + 0.05, 2)}, 1]")
            if s.g_2_dir == "r":
                if [round(s.g_2_x + 0.05, 2), round(s.g_2_y, 2), 1] in s.koords:
                    #print("wall")
                    s.change_dir_g2 = True
                else:
                    move_ghost_2(s.ghost_speed, 0)


            elif s.g_2_dir == "l":
                if [round(s.g_2_x - 0.05, 2), round(s.g_2_y, 2), 1] in s.koords:
                    #print("wall")
                    s.change_dir_g2 = True
                else:
                    move_ghost_2(s.ghost_speed * -1, 0)


            elif s.g_2_dir == "d":
                if [round(s.g_2_x, 2), round(s.g_2_y + 0.05, 2), 1] in s.koords:
                    #print("wall")
                    s.change_dir_g2 = True
                else:
                    move_ghost_2(0, s.ghost_speed)


            elif s.g_2_dir == "u":
                if [round(s.g_2_x, 2), round(s.g_2_y - 0.05, 2), 1] in s.koords:
                    #print("wall")
                    s.change_dir_g2 = True
                else:
                    move_ghost_2(0, s.ghost_speed * -1)

            for koord in turn_points:
                if s.g_2_x > koord[0] + 0 and s.g_2_x < koord[0] + 0.05:
                    if s.g_2_y > koord[1] + 0 and s.g_2_y < koord[1] + 0.01:
                        print("COULD TURN")
                        if len(str(round(round(s.g_2_x, 2), 2))) == 3 or str(round(s.g_2_x, 2)).endswith("5"):
                            if len(str(round(round(s.g_2_y, 2), 2))) == 3 or str(round(s.g_2_y, 2)).endswith("5"):
                                if not [round(s.g_2_y, 2), round(s.g_2_x, 2)] in s.last_three_turns_g2:
                                    if random.randint(1, 5) > 1:
                                        print("TURNING")
                                        s.last_three_turns_g2.remove(s.last_three_turns_g2[0])
                                        s.last_three_turns_g2.append([round(s.g_2_y, 2), round(s.g_2_x, 2)])
                                        s.change_dir_g2 = True



            if s.change_dir_g2:
                change_list = [1, 2, 3, 4 ,2, 2]
                random.shuffle(change_list)
                for v in range(0, 3):
                    #print(v)
                    #print(change_list)
                    if change_list[v] == 1: #ChangeToRight
                        #print("TRYING RIGHT")
                        if not [round(s.g_2_x + 0.05, 2), round(s.g_2_y, 2), 1] in s.koords:
                            s.g_2_dir = "r"
                            break
    #

                    elif change_list[v] == 2: #ChangeToLeft
                        #print("TRYING LEFT")
                        if not [round(s.g_2_x - 0.05, 2), round(s.g_2_y, 2), 1] in s.koords:
                            s.g_2_dir = "l"
                            break


                    elif change_list[v] == 4: #ChangeToUp
                        #print("TRYING UP")
                        if not [round(s.g_2_x, 2), round(s.g_2_y - 0.05, 2), 1] in s.koords:
                            s.g_2_dir = "u"
                            break


                    elif change_list[v] == 3: #ChangeToDown
                        #print("TRYING DOWN")
                        if not [round(s.g_2_x, 2), round(s.g_2_y + 0.05, 2), 1] in s.koords:
                            s.g_2_dir = "d"
                            break
                s.change_dir_g2 = False

            if s.g_2_x > 1:
                s.g_2_x = -0.05
            if s.g_2_x < -0.05:
                s.g_2_x = 1

            if s.powerup_active:
                if s.g_2_x > s.p_x + 0.0 and s.g_2_x < s.p_x + 0.05:
                    if s.g_2_y > s.p_y + 0 and s.g_2_y < s.p_y + 0.01:
                        for p in range(3):
                            s.g_2_dir = "u"
                            time.sleep(0.1)
                            s.g_2_dir = "r"
                            time.sleep(0.1)
                            s.g_2_dir = "d"
                            time.sleep(0.1)
                            s.g_2_dir = "l"
                            time.sleep(0.1)
                        s.g_2_y = 0.5
                        s.g_2_x = 0.5
                        while s.powerup_active:
                            s.g_2_dir = "l"
                            time.sleep(0.1)
                            s.g_2_dir = "d"
                            time.sleep(0.1)
                            s.g_2_dir = "e"
                            time.sleep(0.1)
                            s.g_2_dir = "u"
                            time.sleep(0.1)


    def ghost_3_logic():
        if not s.prep_g3:
            s.g_3_x = 0.5
            s.g_3_y = 0.5
            s.last_three_turns_g3 = [
                [None, None],
                [None, None],
            ]
            s.change_dir_g3 = False
            s.prep_g3 = True
        if s.prep_g3:
            #
            # print(f"[{round(s.g_3_x, 2)},  {round(s.g_3_y + 0.05, 2)}, 1]")
            if s.g_3_dir == "r":
                if [round(s.g_3_x + 0.05, 2), round(s.g_3_y, 2), 1] in s.koords:
                    # print("wall")
                    s.change_dir_g3 = True
                else:
                    move_ghost_3(s.ghost_speed, 0)


            elif s.g_3_dir == "l":
                if [round(s.g_3_x - 0.05, 2), round(s.g_3_y, 2), 1] in s.koords:
                    # print("wall")
                    s.change_dir_g3 = True
                else:
                    move_ghost_3(s.ghost_speed * -1, 0)


            elif s.g_3_dir == "d":
                if [round(s.g_3_x, 2), round(s.g_3_y + 0.05, 2), 1] in s.koords:
                    # print("wall")
                    s.change_dir_g3 = True
                else:
                    move_ghost_3(0, s.ghost_speed)


            elif s.g_3_dir == "u":
                if [round(s.g_3_x, 2), round(s.g_3_y - 0.05, 2), 1] in s.koords:
                    # print("wall")
                    s.change_dir_g3 = True
                else:
                    move_ghost_3(0, s.ghost_speed * -1)

            for koord in turn_points:
                if s.g_3_x > koord[0] + 0 and s.g_3_x < koord[0] + 0.05:
                    if s.g_3_y > koord[1] + 0 and s.g_3_y < koord[1] + 0.01:
                        if len(str(round(round(s.g_3_x, 2), 2))) == 3 or str(round(s.g_3_x, 2)).endswith("5"):
                            if len(str(round(round(s.g_3_y, 2), 2))) == 3 or str(round(s.g_3_y, 2)).endswith("5"):
                                if not [round(s.g_3_y, 2), round(s.g_3_x, 2)] in s.last_three_turns_g3:
                                    if random.randint(1, 5) > 1:
                                        s.last_three_turns_g3.remove(s.last_three_turns_g3[0])
                                        s.last_three_turns_g3.append([round(s.g_3_y, 2), round(s.g_3_x, 2)])
                                        s.change_dir_g3 = True

            if s.change_dir_g3:
                change_list = [1, 2, 3, 4, 3, 3]
                random.shuffle(change_list)
                for v in range(0, 3):
                    # print(v)
                    # print(change_list)
                    if change_list[v] == 1:  # ChangeToRight
                        # print("TRYING RIGHT")
                        if not [round(s.g_3_x + 0.05, 2), round(s.g_3_y, 2), 1] in s.koords:
                            s.g_3_dir = "r"
                            break
                    #

                    elif change_list[v] == 2:  # ChangeToLeft
                        # print("TRYING LEFT")
                        if not [round(s.g_3_x - 0.05, 2), round(s.g_3_y, 2), 1] in s.koords:
                            s.g_3_dir = "l"
                            break


                    elif change_list[v] == 3:  # ChangeToUp
                        # print("TRYING UP")
                        if not [round(s.g_3_x, 2), round(s.g_3_y - 0.05, 2), 1] in s.koords:
                            s.g_3_dir = "u"
                            break


                    elif change_list[v] == 4:  # ChangeToDown
                        # print("TRYING DOWN")
                        if not [round(s.g_3_x, 2), round(s.g_3_y + 0.05, 2), 1] in s.koords:
                            s.g_3_dir = "d"
                            break
                s.change_dir_g3 = False

            if s.g_3_x > 1:
                s.g_3_x = -0.05
            if s.g_3_x < -0.05:
                s.g_3_x = 1

            if s.powerup_active:
                if s.g_3_x > s.p_x + 0.0 and s.g_3_x < s.p_x + 0.05:
                    if s.g_3_y > s.p_y + 0 and s.g_3_y < s.p_y + 0.01:
                        for p in range(3):
                            s.g_3_dir = "u"
                            time.sleep(0.1)
                            s.g_3_dir = "r"
                            time.sleep(0.1)
                            s.g_3_dir = "d"
                            time.sleep(0.1)
                            s.g_3_dir = "l"
                            time.sleep(0.1)
                        s.g_3_y = 0.5
                        s.g_3_x = 0.5
                        while s.powerup_active:
                            s.g_3_dir = "u"
                            time.sleep(0.1)
                            s.g_3_dir = "r"
                            time.sleep(0.1)
                            s.g_3_dir = "d"
                            time.sleep(0.1)
                            s.g_3_dir = "l"
                            time.sleep(0.1)



    def ghost_4_logic():
        if not s.prep_g4:
            s.g_4_x = 0.5
            s.g_4_y = 0.5
            s.last_three_turns_g4 = [
                                [None, None],
                                [None, None],
                                ]
            s.change_dir_g4 = False
            s.prep_g4 = True
        if s.prep_g4:
            #
            #print(f"[{round(s.g_4_x, 2)},  {round(s.g_4_y + 0.05, 2)}, 1]")
            if s.g_4_dir == "r":
                if [round(s.g_4_x + 0.05, 2), round(s.g_4_y, 2), 1] in s.koords:
                    #print("wall")
                    s.change_dir_g4 = True
                else:
                    move_ghost_4(s.ghost_speed, 0)


            elif s.g_4_dir == "l":
                if [round(s.g_4_x - 0.05, 2), round(s.g_4_y, 2), 1] in s.koords:
                    #print("wall")
                    s.change_dir_g4 = True
                else:
                    move_ghost_4(s.ghost_speed * -1, 0)


            elif s.g_4_dir == "d":
                if [round(s.g_4_x, 2), round(s.g_4_y + 0.05, 2), 1] in s.koords:
                    #print("wall")
                    s.change_dir_g4 = True
                else:
                    move_ghost_4(0, s.ghost_speed)


            elif s.g_4_dir == "u":
                if [round(s.g_4_x, 2), round(s.g_4_y - 0.05, 2), 1] in s.koords:
                    #print("wall")
                    s.change_dir_g4 = True
                else:
                    move_ghost_4(0, s.ghost_speed * -1)


            for koord in turn_points:
                if s.g_4_x > koord[0] + 0 and s.g_4_x < koord[0] + 0.05:
                    if s.g_4_y > koord[1] + 0 and s.g_4_y < koord[1] + 0.01:
                        if len(str(round(round(s.g_4_x, 2), 2))) == 3 or str(round(s.g_4_x, 2)).endswith("5"):
                            if len(str(round(round(s.g_4_y, 2), 2))) == 3 or str(round(s.g_4_y, 2)).endswith("5"):
                                if not [round(s.g_4_y, 2), round(s.g_4_x, 2)] in s.last_three_turns_g4:
                                    if random.randint(1, 5) > 1:
                                        s.last_three_turns_g4.remove(s.last_three_turns_g4[0])
                                        s.last_three_turns_g4.append([round(s.g_4_y, 2), round(s.g_4_x, 2)])
                                        s.change_dir_g4 = True




            if s.change_dir_g4:
                change_list = [1, 2, 3, 4, 4, 4]
                random.shuffle(change_list)
                for v in range(0, 3):
                    #print(v)
                    #print(change_list)
                    if change_list[v] == 1: #ChangeToRight
                        #print("TRYING RIGHT")
                        if not [round(s.g_4_x + 0.05, 2), round(s.g_4_y, 2), 1] in s.koords:
                            s.g_4_dir = "r"
                            break
    #

                    elif change_list[v] == 2: #ChangeToLeft
                        #print("TRYING LEFT")
                        if not [round(s.g_4_x - 0.05, 2), round(s.g_4_y, 2), 1] in s.koords:
                            s.g_4_dir = "l"
                            break


                    elif change_list[v] == 3: #ChangeToUp
                        #print("TRYING UP")
                        if not [round(s.g_4_x, 2), round(s.g_4_y - 0.05, 2), 1] in s.koords:
                            s.g_4_dir = "u"
                            break


                    elif change_list[v] == 4: #ChangeToDown
                        #print("TRYING DOWN")
                        if not [round(s.g_4_x, 2), round(s.g_4_y + 0.05, 2), 1] in s.koords:
                            s.g_4_dir = "d"
                            break
                s.change_dir_g4 = False

            if s.g_4_x > 1:
                s.g_4_x = -0.05
            if s.g_4_x < -0.05:
                s.g_4_x = 1

            if s.powerup_active:
                if s.g_4_x > s.p_x + 0.0 and s.g_4_x < s.p_x + 0.05:
                    if s.g_4_y > s.p_y + 0 and s.g_4_y < s.p_y + 0.01:
                        for p in range(3):
                            s.g_4_dir = "u"
                            time.sleep(0.1)
                            s.g_4_dir = "r"
                            time.sleep(0.1)
                            s.g_4_dir = "d"
                            time.sleep(0.1)
                            s.g_4_dir = "l"
                            time.sleep(0.1)
                        s.g_4_y = 0.5
                        s.g_4_x = 0.5
                        while s.powerup_active:
                            s.g_4_dir = "l"
                            time.sleep(0.1)
                            s.g_4_dir = "d"
                            time.sleep(0.1)
                            s.g_4_dir = "e"
                            time.sleep(0.1)
                            s.g_4_dir = "u"
                            time.sleep(0.1)



    def controls():
        if True:
            #print(f"[{round(s.p_x, 2)}, {round(s.p_y, 2)}, 1]")
            if keyboard.is_pressed("w") or keyboard.is_pressed("up"):
                if not [round(s.p_x, 2), round(s.p_y - 0.05, 2), 1] in s.koords and not [round(s.p_x, 2), round(s.p_y - 0.05, 2), 2] in s.koords:
                    if s.old_dir_pm == "u":
                        s.p_dir = "u"
                    else:
                        if len(str(round(round(s.p_x, 2), 2))) == 3 or str(round(round(s.p_x, 2), 2)).endswith("5"):
                            s.p_dir = "u"

            if keyboard.is_pressed("a") or keyboard.is_pressed("left"):
                if not [round(s.p_x - 0.05, 2), round(s.p_y, 2), 1] in s.koords and not [round(s.p_x - 0.05, 2), round(s.p_y, 2), 2] in s.koords:
                    if s.old_dir_pm == "l":
                        s.p_dir = "l"
                    else:
                        if len(str(round(round(s.p_y, 2), 2))) == 3 or str(round(round(s.p_y, 2), 2)).endswith("5"):
                            s.p_dir = "l"

            if keyboard.is_pressed("s") or keyboard.is_pressed("down"):
                if not [round(s.p_x, 2), round(s.p_y + 0.05, 2), 1] in s.koords and not [round(s.p_x, 2), round(s.p_y + 0.05, 2), 2] in s.koords:
                    print("Can Move")
                    if s.old_dir_pm == "d":
                        s.p_dir = "d"
                    else:
                        if len(str(round(round(s.p_x, 2), 2))) == 3 or str(round(round(s.p_x, 2), 2)).endswith("5"):
                            s.p_dir = "d"

            if keyboard.is_pressed("d") or keyboard.is_pressed("right"):
                if not [round(s.p_x + 0.05, 2), round(s.p_y, 2), 1] in s.koords and not [round(s.p_x + 0.05, 2) , round(s.p_y, 2), 2] in s.koords:
                    if s.old_dir_pm == "r":
                        s.p_dir = "r"
                    else:
                        if len(str(round(round(s.p_y, 2), 2))) == 3 or str(round(round(s.p_y, 2), 2)).endswith("5"):
                            s.p_dir = "r"



            if s.p_dir == "u":
                if not [round(s.p_x, 2), round(s.p_y - 0.05, 2), 1] in s.koords and not [round(s.p_x, 2),
                                                                                         round(s.p_y, 2) - 0.05,
                                                                                         2] in s.koords:
                    move_pacman(0, -0.1)
            elif s.p_dir == "l":
                if not [round(s.p_x - 0.05, 2), round(s.p_y, 2), 1] in s.koords and not [round(s.p_x, 2) - 0.05,
                                                                                         round(s.p_y, 2), 2] in s.koords:
                    move_pacman(-0.1, 0)
            elif s.p_dir == "d":
                if not [round(s.p_x, 2), round(s.p_y + 0.05, 2), 1] in s.koords and not [round(s.p_x, 2), round(s.p_y, 2) + 0.05, 2] in s.koords:
                    move_pacman(0, 0.1)
            elif s.p_dir == "r":
                if not [round(s.p_x + 0.05, 2), round(s.p_y, 2), 1] in s.koords and not [round(s.p_x, 2) + 0.05,
                                                                                         round(s.p_y, 2), 2] in s.koords:
                    move_pacman(0.1, 0)

            if s.p_x > 1:
                s.p_x = -0.05
            if s.p_x < -0.05:
                s.p_x = 1

            s.collected_coin_blocks.append(coins[1][0])

            for coin_props in coins:
                p_c_x = round(s.p_x, 3)
                p_c_y = round(s.p_y, 3)
                if [round(p_c_x, 3), round(p_c_y, 3)] == [round(coin_props[1] - 0.015, 3), round(coin_props[2] - 0.015, 3)]:
                    if not coin_props[0] in s.collected_coin_blocks:
                        s.collected_coin_blocks.append(coin_props[0])
                        s.all_collected_count += 1

    #pacman
    s.pacman = tk.Label(frame)
    s.pacman.place(relx=s.p_x, rely=s.p_y)


    def control_function():
        while True:
            time.sleep(0.03333333333333337)
            ghost_1_logic()
            ghost_2_logic()
            ghost_3_logic()
            ghost_4_logic()
            controls()


    control_func_logic_thread = threading.Thread(target=control_function)
    control_func_logic_thread.start()



    old_dir_g1 = "None"
    old_dir_g2 = "None"
    old_dir_g3 = "None"
    old_dir_g4 = "None"
    pac_img_counter = 0.0
    old_p_img_counter = 0








    #maingame
    while True:
        time.sleep(0.03333333333333337)

        for coinblock in s.collected_coin_blocks:
            coinblock.place_configure(relx=2)

        # pacman dirs
        pic_xy = 1
        # pac
        set_pos_x, set_pos_y = round(s.p_x, 2), round(s.p_y, 2)
        if s.p_dir == "u" or s.p_dir == "d":
            set_pos_x = 0.05 * round(s.p_x / 0.05)
        if s.p_dir == "l" or s.p_dir == "r":
            set_pos_y = 0.05 * round(s.p_y / 0.05)

        #print(f"{set_pos_x} ; {set_pos_x} + {s.p_dir}")
        s.pacman.place_configure(relx=set_pos_x + 0.0115, rely=set_pos_y + 0.0115)


        if pac_img_counter > 3.0:
            pac_img_counter = 0
        else:
            pac_img_counter += 0.2
        if s.old_dir_pm != s.p_dir or old_p_img_counter != round(pac_img_counter):
            old_p_img_counter = round(pac_img_counter)
            s.old_dir_pm = s.p_dir
            if s.p_dir == "r":
                p_bits = img_bits.pacman_codes()[3][int(round(pac_img_counter))]
            elif s.p_dir == "u":
                p_bits = img_bits.pacman_codes()[0][int(round(pac_img_counter))]
            elif s.p_dir == "d":
                p_bits = img_bits.pacman_codes()[1][int(round(pac_img_counter))]
            elif s.p_dir == "l":
                p_bits = img_bits.pacman_codes()[2][int(round(pac_img_counter))]

            s.pacman.configure(width=pic_xy * len(p_bits[0]), height=pic_xy * len(p_bits), background=frame["bg"],
                                bd=0, highlightthickness=0)

            colors = {
                0: (255, 255, 0),
                1: (0, 0, 0)
            }
            width = len(p_bits[0])
            height = len(p_bits)
            image = Image.new('RGB', (width, height))
            for y, row in enumerate(p_bits):
                for x, value in enumerate(row):
                    color = colors[value]
                    image.putpixel((x, y), color)
            pacman_img = ImageTk.PhotoImage(image)
            s.pacman.configure(image=pacman_img)

















        #ghost dirs
        pic_xy = 1
        #g1
        s.ghost_1.place_configure(relx=s.g_1_x + 0.01, rely=s.g_1_y + 0.01)

        if old_dir_g1 != s.g_1_dir:
            old_dir_g1 = s.g_1_dir
            if s.g_1_dir == "r":
                g_1_bits = img_bits.ghost_codes()[0]
            elif s.g_1_dir == "u":
                g_1_bits = img_bits.ghost_codes()[1]
            elif s.g_1_dir == "d":
                g_1_bits = img_bits.ghost_codes()[2]
            elif s.g_1_dir == "l":
                g_1_bits = img_bits.ghost_codes()[3]

            s.ghost_1.configure(width=pic_xy * len(g_1_bits[0]), height=pic_xy * len(g_1_bits), background=frame["bg"],
                                bd=0, highlightthickness=0)

            colors = {
                0: (255, 0, 0),
                1: (255, 255, 255),
                2: (0, 34, 255),
                3: (0, 0, 0)
            }
            width = len(g_1_bits[0])
            height = len(g_1_bits)
            image = Image.new('RGB', (width, height))
            for y, row in enumerate(g_1_bits):
                for x, value in enumerate(row):
                    color = colors[value]
                    image.putpixel((x, y), color)
            ghost_1_img = ImageTk.PhotoImage(image)
            s.ghost_1.configure(image=ghost_1_img)




        # ghost dirs
        pic_xy = 1
        # g2
        s.ghost_2.place_configure(relx=s.g_2_x + 0.01, rely=s.g_2_y + 0.01)

        if old_dir_g2 != s.g_2_dir:
            old_dir_g2 = s.g_2_dir
            if s.g_2_dir == "r":
                g_2_bits = img_bits.ghost_codes()[0]
            elif s.g_2_dir == "u":
                g_2_bits = img_bits.ghost_codes()[1]
            elif s.g_2_dir == "d":
                g_2_bits = img_bits.ghost_codes()[2]
            elif s.g_2_dir == "l":
                g_2_bits = img_bits.ghost_codes()[3]

            s.ghost_2.configure(width=pic_xy * len(g_2_bits[0]), height=pic_xy * len(g_2_bits), background=frame["bg"],
                                    bd=0, highlightthickness=0)

            colors = {
                0: (255, 184, 82),
                1: (255, 255, 255),
                2: (0, 34, 255),
                3: (0, 0, 0)
            }
            width = len(g_2_bits[0])
            height = len(g_2_bits)
            image = Image.new('RGB', (width, height))
            for y, row in enumerate(g_2_bits):
                for x, value in enumerate(row):
                    color = colors[value]
                    image.putpixel((x, y), color)
            ghost_2_img = ImageTk.PhotoImage(image)
            s.ghost_2.configure(image=ghost_2_img)




        # ghost dirs
        pic_xy = 1
        # g3
        s.ghost_3.place_configure(relx=s.g_3_x + 0.01, rely=s.g_3_y + 0.01)

        if old_dir_g3 != s.g_3_dir:
            old_dir_g3 = s.g_3_dir
            if s.g_3_dir == "r":
                g_3_bits = img_bits.ghost_codes()[0]
            elif s.g_3_dir == "u":
                g_3_bits = img_bits.ghost_codes()[1]
            elif s.g_3_dir == "d":
                g_3_bits = img_bits.ghost_codes()[2]
            elif s.g_3_dir == "l":
                g_3_bits = img_bits.ghost_codes()[3]

            s.ghost_3.configure(width=pic_xy * len(g_3_bits[0]), height=pic_xy * len(g_3_bits),
                                        background=frame["bg"],
                                        bd=0, highlightthickness=0)

            colors = {
                0: (255, 184, 255),
                1: (255, 255, 255),
                2: (0, 34, 255),
                3: (0, 0, 0)
            }
            width = len(g_3_bits[0])
            height = len(g_3_bits)
            image = Image.new('RGB', (width, height))
            for y, row in enumerate(g_3_bits):
                for x, value in enumerate(row):
                    color = colors[value]
                    image.putpixel((x, y), color)
            ghost_3_img = ImageTk.PhotoImage(image)
            s.ghost_3.configure(image=ghost_3_img)



        # g4
        s.ghost_4.place_configure(relx=s.g_4_x + 0.01, rely=s.g_4_y + 0.01)

        if old_dir_g4 != s.g_4_dir:
            old_dir_g4 = s.g_4_dir
            if s.g_4_dir == "r":
                g_4_bits = img_bits.ghost_codes()[0]
            elif s.g_4_dir == "u":
                g_4_bits = img_bits.ghost_codes()[1]
            elif s.g_4_dir == "d":
                g_4_bits = img_bits.ghost_codes()[2]
            elif s.g_4_dir == "l":
                g_4_bits = img_bits.ghost_codes()[3]

            s.ghost_4.configure(width=pic_xy * len(g_4_bits[0]), height=pic_xy * len(g_4_bits),
                                        background=frame["bg"],
                                        bd=0, highlightthickness=0)

            colors = {
                0: (0, 255, 255),
                1: (255, 255, 255),
                2: (0, 34, 255),
                3: (0, 0, 0)
            }
            width = len(g_4_bits[0])
            height = len(g_4_bits)
            image = Image.new('RGB', (width, height))
            for y, row in enumerate(g_4_bits):
                for x, value in enumerate(row):
                    color = colors[value]
                    image.putpixel((x, y), color)
            ghost_4_img = ImageTk.PhotoImage(image)
            s.ghost_4.configure(image=ghost_4_img)









        frame.update() #FRAMEUPDATE---FRAMEUPDATE---FRAMEUPDATE---FRAMEUPDATE---FRAMEUPDATE---FRAMEUPDATE---FRAMEUPDATE---FRAMEUPDATE---FRAMEUPDATE---FRAMEUPDATE---FRAMEUPDATE---

        if not s.caught:
            for ghost in [[s.ghost_1, s.g_1_x, s.g_1_y], [s.ghost_2, s.g_2_x, s.g_2_y], [s.ghost_3, s.g_3_x, s.g_3_y], [s.ghost_4, s.g_4_x, s.g_4_y]]:
                px, py = s.p_x, s.p_y
                barrier_start = [px - 0.01, py - 0.01]
                barrier_end = [px + 0.051, py + 0.051]
                if ghost[1] > barrier_start[0] and ghost[2] > barrier_start[1]:
                    if ghost[1] < barrier_end[0] and ghost[2] < barrier_end[1]:
                        ghost[0].place_configure(relx=px + 0.01, rely=py + 0.01)
                        frame.update()
                        time.sleep(2.5)
                        reset()
                        frame.update()

        if s.all_coins_count - 1 <= s.all_collected_count:
            print("YOU WIN")
            frame.update()
            time.sleep(2.5)
            reset()
            frame.update()


except Exception as e:
    if 'invoke "place" command: application has been destroyed' in str(e):
        raise SystemExit
    elif sys.platform == "win32":
        ctypes.windll.user32.ShowWindow(ctypes.windll.kernel32.GetConsoleWindow(), 1)
    print("\n\n")
    print("---" * 500)
    print("---" * 500)
    print("---" * 500)
    print(f"FATAL ERROR:\n\n{str(e)}")